unit UGrafico;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, ADODB, ExtCtrls, TeeProcs, TeEngine, Chart, DBChart,
  StdCtrls, Buttons, Series, Mask, DBCtrls,
  Menus, Spin, DBClient,

  Printers;

type
  TFrmGrafico = class(TForm)
    DBChart1: TDBChart;
    btnSalvar: TBitBtn;
    btnImprimir: TBitBtn;
    btnAnterior: TBitBtn;
    btnProxima: TBitBtn;
    btnPrimeira: TBitBtn;
    btnUltima: TBitBtn;
    PrintDialog1: TPrintDialog;
    btnFechar: TBitBtn;
    ClientDataSet1: TClientDataSet;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnSalvarClick(Sender: TObject);
    procedure DBChart1PageChange(Sender: TObject);
    procedure btnImprimirClick(Sender: TObject);
    procedure btnFecharClick(Sender: TObject);
    procedure ClientDataSet1AfterOpen(DataSet: TDataSet);
    procedure btnAnteriorClick(Sender: TObject);
  private
    { Private declarations }
    pgs: Byte;
  public
    { Public declarations }
  end;

var
  FrmGrafico: TFrmGrafico;

implementation

uses USalvarGrafico, UProgresso;

{$R *.DFM}

procedure TFrmGrafico.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  ClientDataSet1.close;
end;

procedure TFrmGrafico.btnSalvarClick(Sender: TObject);
begin
  TFrmSalvarGrafico.Execute(Self, DBChart1);
end;

procedure TFrmGrafico.DBChart1PageChange(Sender: TObject);
begin
  DBChart1.Foot.Text.Text:=
    Format('Pgina %d de %d', [DBChart1.Page, pgs]);
end;

procedure TFrmGrafico.btnImprimirClick(Sender: TObject);
//origem  em qual pgina estava antes da impresso
//h = heigth, w = width (utilizadas pra definar as margens da impresso
var h, w, i, inicio, fim, origem: longint;
begin
   btnImprimir.Enabled := false;
   try
     {configura o PrintDialog para que
     a janela de configurao de impresso
     mostre o intervalo de pginas
     que podem ser impressas}
     PrintDialog1.FromPage := 1;
     PrintDialog1.MaxPage := pgs;
     PrintDialog1.ToPage := pgs;
     {abre a janela de configurao de impresso
     para o usurio poder escolher a impressora
     e outras configuraes}
     if PrintDialog1.execute then
     begin
       {se o usurio escolheu imprimir
       todas as pginas}
       if PrintDialog1.PrintRange = prAllPages then
       begin
         inicio:= 1;
         fim:= PrintDialog1.MaxPage;
       end
       {se o usurio escolheu imprimir um intervalo
       de pginas}
       else
       begin
         inicio:= PrintDialog1.FromPage;
         fim:= PrintDialog1.ToPage;
       end;
       {pega a pgina que o grfico estava antes
       do incio da impreso}
       origem:= DBChart1.Page;

       {cria o form de progresso definindo
       o seu dono como Self (o prprio form
       do grfico) e o MaxValue sendo o fim - inicio + 1.
       Se a pgina inicial for 2 e a final para impresso for
       5, ento, 5 - 2 + 1 = 4. Quatro  o total
       de pginas a serem impressas. Execute  o
       mtodo de Classe que foi criado na classe TFrmProgresso}
       TFrmProgresso.Execute(Self, fim - inicio + 1);
       try
         {a funo Printer, que d acesso  impressora, est na Unit Printers}

         {muda a orientao do papel para Paisagem}
         Printer.Orientation := poLandscape;
         //define o ttulo do documento que vai para a impressora
         Printer.Title := trim(DBChart1.Title.Text.Text);
         //inicia um novo documento na fila de impresso
         Printer.BeginDoc;
         try
           {lao para imprimir o grfico
           percorrendo as pginas do mesmo
           e mandando para impresso}
           for i:= inicio to fim do
           begin
              {se o FrmProgresso for igual a nil
               porque o usurio cancelou a impresso
              fechando o formulrio de progresso, assim
              a impresso  abortada}
              if FrmProgresso = nil then
              begin
                 Printer.Abort;
                 exit;
              end;
              {adiciona 1 ao progresso do Gauge
              fazendo com que a barra de progresso
              do mesmo aumente}
              FrmProgresso.Gauge1.AddProgress(1);
              {altera a pgina atual do grfico
              para imprim-la}
              DBChart1.Page := i;

              h:=Printer.PageHeight;
              w:=Printer.PageWidth;
              {Imprime a pgina atual do grfico
              definindo um retngulo (Rect) de impresso
              dentro da pgina da impressora. O primeiro parmetro
              define a margem esquerda, o segundo a superior,
              o terceiro a largura e o quarto a altura}
              DBChart1.PrintPartial(Rect(15, 15,w - 15,h - 15) );
              {Cria uma nova pgina na impressora
              somente se a pgina atual do grfico
              no for a ltima, evitando que fique
              uma pgina a mais no final da impresso.}
              if i < fim then
                 Printer.NewPage;
           end;
         except
           //se ocorrer erro ento aborta a impresso
           Printer.Abort;
           Raise;
         end;

         //finaliza documento
         Printer.EndDoc;
       finally
         {Quando o processo de impresso terminar,
         tenha dado erro ou no (Finally), volta para
         a pgina que estava antes da impresso}
         DBChart1.Page:= origem;
         if FrmProgresso <> nil then
            FrmProgresso.close;
       end;
     end;
   finally
     btnImprimir.Enabled := true;
   end;
end;

procedure TFrmGrafico.btnFecharClick(Sender: TObject);
begin
  close;
end;

procedure TFrmGrafico.ClientDataSet1AfterOpen(DataSet: TDataSet);
begin
  {verifica se o a primeira srie do grfico
   em formato de Pizza}
  if DBChart1.Series[0] is TPieSeries then
     pgs:= 1
  else pgs:= DBChart1.NumPages;
  {executa o procedimento click
  do boto que vai para a primeira
  pgina do grfico, fazendo
  o controlde de habilitao/desabilitao
  dos botes de navegao}
  btnPrimeira.click;
  {chama o procedimento associado ao evento
  PageChange do DBChart para exibir
  o nmero da pgina no rodap do grfico}
  DBChart1PageChange(DBChart1);
end;

procedure TFrmGrafico.btnAnteriorClick(Sender: TObject);
begin
  {navegar nas pginas do grfico verificando,
  atravs do parmetro Sender, qual o boto
  que foi clicado}
  if sender = btnAnterior then
    DBChart1.PreviousPage
  else if sender = btnProxima then
     DBChart1.NextPage
  else if sender = btnPrimeira then
     DBChart1.Page := 1
  else if sender = btnUltima then
     DBChart1.Page := pgs;

  {habilitar/desabilitar os botes}
  btnPrimeira.enabled:= (DBChart1.Page > 1);
  btnAnterior.enabled:= btnPrimeira.Enabled;
  btnProxima.enabled:= (DBChart1.Page < pgs);
  btnUltima.enabled:= btnProxima.Enabled;
end;

end.
